%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            CDMA_Rx.m
%  Description:         CDMA߽ͨϵͳ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2018-8-8
%       Author:         tony liu
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
clear

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 
rx_crc1_num=8;         %ŵ1CRC bitλѡ081216
rx_crc2_num=8;         %ŵ1CRC bitλѡ081216
rx_coder_type1=1;      %ŵ룬0ʾ룬1ʾ1/2룬2ʾ1/3
rx_coder_type2=1;      %ŵ룬0ʾ룬1ʾ1/2룬2ʾ1/3

ch1_sf_rx=128;           %Ƶӣ8,16,32,64,128
ch2_sf_rx=128;         %Ƶӣ8,16,32,64,128
ch1_code_rx=1;         % 1-64 
ch2_code_rx=2;         % 1-8

sampleRate=2;
rf_switch=1;
tx_data=zeros(1,51200);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Ƶշ
if rf_switch==0
    rx_data=tx_data;
    
else
    system_type=1;
    [rx_data] = CDMA_RxRFloopback( tx_data,system_type);
end
figure
plot(real(rx_data))


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ˲
[rxData]=CDMA_RxFilter(rx_data,sampleRate);
rx_data=rxData;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ʱ϶ͬ
[searchFlag, timeslotStart, PscCorr] = CDMA_RxTimeslotSyn(rx_data, sampleRate, 2560*sampleRate);
figure
plot(PscCorr);
if searchFlag==1
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% ֡ͬ
    [searchFlag1, scrambleGroupNo, firstTimeslotNo,rx_data1] = CDMA_RxFrameSyn(rx_data, sampleRate, timeslotStart);
    scrambleGroupNo
    if searchFlag1==1
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Ѱ
        [scrambleNo,scramblingCode] = CDMA_RxSCSearch(rx_data1, sampleRate, scrambleGroupNo);
        scrambleNo
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% 
        rx_data1 = rx_data1./scramblingCode;

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% 

        %PICHŵ
        [pichData] = CDMA_RxDespread(rx_data1, 256, 0, sampleRate);
        %ŵ1
        [dpch1Data] = CDMA_RxDespread(rx_data1, ch1_sf_rx, ch1_code_rx, sampleRate);
        %ŵ2
        [dpch2Data] = CDMA_RxDespread(rx_data1, ch2_sf_rx, ch2_code_rx, sampleRate);

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% ʱƵͬ
        [dpch1Bit, data1A] = CDMA_RxDemodulate(dpch1Data, pichData);
        [dpch2Bit, ~] = CDMA_RxDemodulate(dpch2Data, pichData);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% ŵ
        [ch1_decode_data] = CDMA_RxTrchDecoder(dpch1Bit, rx_coder_type1);
        [ch2_decode_data] = CDMA_RxTrchDecoder(dpch2Bit, rx_coder_type2);

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% CRC
        [CRC_flag1] = CDMA_RxCRC(ch1_decode_data, rx_crc1_num);
        [CRC_flag2] = CDMA_RxCRC(ch2_decode_data, rx_crc2_num);

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% Դ
        if CRC_flag1==1
            [rx_char_msg1]= CDMA_RxMsgDecode(ch1_decode_data)
        else
            disp('ŵ1 CRCУ');
        end
        if CRC_flag2==1
            [rx_char_msg2]= CDMA_RxMsgDecode(ch2_decode_data)
        else
            disp('ŵ1 CRCУ');
        end
    else
        disp('֡ͬʧ');
    end
else
    disp('ʱ϶ͬʧ');
end